/////////////////////////////////////////////////////////////
// CINEMA SDK : BITMAP FILTER                              //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_BITMAPFILTER_H
#define __C4D_BITMAPFILTER_H

#include "x4d_filter.h"

class BaseBitmap;

// bitmap stuff
BM_TILE	*BfBitmapTileGet(BM_REF bm, const RECT32 *src_rect, LONG width, LONG height, LONG tile_mode, LONG flags);
LONG		BfBitmapTileDetach(BM_REF bm, BM_TILE *tile_buf, LONG flags );
LONG		BfDiscardChanges( BM_REF bm );
LONG		BfUpdateView( BM_REF bm );
Bool		BfConvertTileToBasebmp( const BM_TILE *tile, const RECT32 *tile_rect, BaseBitmap *bmp, LONG zero );
Bool		BfBitmapTileScale( BM_REF bm, BM_TILE *src_bm, BM_TILE *dst_bm, RECT32 *src_rect, RECT32 *dst_rect );

// progress funtions
PROGRESS_ID	BfProgressNew( void );
LONG				BfProgressDelete( PROGRESS_ID pid );
LONG				BfProgressUpdate( PROGRESS_ID pid, LONG current_value, LONG max_value, const String &text);

BaseContainer GetGlobalFilterPrefs(LONG pluginid);
Bool SetGlobalFilterPrefs(LONG pluginid,const BaseContainer &prefs);

void *GetEditorWindow(void); // get system window handle of the editor window
Bool IsHostWindow(void *win); // check if the windowhandle is one of the cinema windows
#ifdef __MAC
Bool Mac_hostProcessEvent(void *event); // mac event routing
#endif



#endif
